﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;
using GE.Visualisation;
namespace GE.World.Entities
{
    class CameraEntity : WorldEntity
    {
        /// <summary>
        /// Minimum X position defining the safe zone
        /// </summary>
        int _iXMinThreshold;

        /// <summary>
        /// Maximum X position defining the safe zone
        /// </summary>
        int _iXMaxThreshold;

        /// <summary>
        /// Minimum Y position defining the safe zone
        /// </summary>
        int _iYMinThreshold;

        /// <summary>
        /// Maximum Y position defining the safe zone
        /// </summary>
        int _iYMaxThreshold;

        /// <summary>
        /// Indicate which direction the camera cannot move
        /// </summary>
        eLockedDirection _lockDirection;

        /// <summary>
        /// 
        /// </summary>
        bool _bTargetXReached;

        bool _bTargetYReached;

        /// <summary>
        /// 
        /// </summary>
        Vector2 _v2Target;

        /// <summary>
        /// Set the direction locked
        /// </summary>
        public eLockedDirection LockedDirection { set { _lockDirection = value; } }
#if !GAME
        public static string EDITOR_TILESET { get { return "editorSprite.xml"; } }

        public static string EDITOR_SPRITE { get { return "camera"; } }
#endif
        public bool IsPlayerInSafeZone
        {
            get
            {
                //calculate the screen position :  Screen = World - Camera
                Vector2 playerScreenPosition = World.Instance.PlayerEntity.Position - _v2Position;

                if ((_iYMinThreshold - playerScreenPosition.Y)> 0) return false;
                if ((playerScreenPosition.Y - _iYMaxThreshold) > 0) return false;
                if ((_iXMinThreshold - playerScreenPosition.X) > 0) return false;
                if ((playerScreenPosition.X - _iXMaxThreshold) > 0) return false;

                return true;
            }
        }

        public void setCenterX(float x)
        {
            _v2Target.X = x - Visu.Instance.ScreenWidth / 2;
            _bTargetXReached = false;
        }

        public void setCenterY(float y)
        {
            _v2Target.Y = y - Visu.Instance.ScreenHeight / 2;
            _bTargetYReached = false;
        }

        public void setOnPlayer()
        {
            _v2Position = World.Instance.PlayerPosition - new Vector2(Visu.Instance.ScreenWidth / 2,
                Visu.Instance.ScreenHeight / 2);
        }

        /// <summary>
        /// Constructor
        /// </summary>
        public CameraEntity()
        {
            _bTargetXReached = true;
            _bTargetYReached = true;
            _v2Position = new Vector2(0, 0);

            _iXMaxThreshold = 0;
            _iXMinThreshold = 0;
            _iYMaxThreshold = 0;
            _iYMinThreshold = 0;
            _lockDirection = eLockedDirection.eLockedNone;

        }

        public override void init()
        {
            const float RATIO_THRESHOLD = 0.4f;

            _iXMinThreshold = (int)(Visu.Instance.ScreenWidth * RATIO_THRESHOLD);
            _iXMaxThreshold = Visu.Instance.ScreenWidth - _iXMinThreshold;
            _iYMinThreshold = (int)(Visu.Instance.ScreenHeight * RATIO_THRESHOLD);
            _iYMaxThreshold = Visu.Instance.ScreenHeight - _iYMinThreshold;

            if ((_lockDirection & eLockedDirection.eLockedVertical) == 0)
            {
                _v2Position.Y = World.Instance.PlayerPosition.Y - Visu.Instance.ScreenHeight / 2;
            }

            if ((_lockDirection & eLockedDirection.eLockedHorizontal) == 0)
            {
                _v2Position.X = World.Instance.PlayerPosition.X - Visu.Instance.ScreenWidth / 2;
            }
        }


        public override void  update()
        {
            const int LIMIT = 5;

            //follow a target
            if (!_bTargetXReached)
            {
                float difference = _v2Position.X - _v2Target.X;
                if (difference > 0)
                {
                    if (difference > LIMIT)
                        _v2Position.X -= LIMIT;
                    else
                    {
                        _v2Position.X = _v2Target.X;
                        _bTargetXReached = true;
                    }
                }
                else
                {
                    if (difference < -LIMIT)
                        _v2Position.X += LIMIT;
                    else
                    {
                        _v2Position.X = _v2Target.X;
                        _bTargetXReached = true;
                    }
                }
            }

            if (!_bTargetYReached)
            {
                float difference = _v2Position.Y - _v2Target.Y;
                if (difference > 0)
                {
                    if (difference > LIMIT)
                        _v2Position.Y -= LIMIT;
                    else
                    {
                        _v2Position.Y = _v2Target.Y;
                        _bTargetYReached = true;
                    }
                }
                else
                {
                    if (difference < -LIMIT)
                        _v2Position.Y += LIMIT;
                    else
                    {

                        _v2Position.Y = _v2Target.Y;
                        _bTargetYReached = true;
                    }
                }
            }

            //calculate the screen position :  Screen = World - Camera
            Vector2 playerScreenPosition = World.Instance.PlayerEntity.Position - _v2Position;

            int redZone = 0;
            
            //check if the camera can move verticaly
            if ((_lockDirection & eLockedDirection.eLockedVertical) == 0)
            {
                //check if the player is inside the safe zone
                redZone = (int)(_iYMinThreshold - playerScreenPosition.Y); //check if the player is too high
                if (redZone > 0)
                {
                    if (redZone < LIMIT)
                        _v2Position.Y -= redZone;
                    else
                        _v2Position.Y -= LIMIT;
                }

                //check if the player is too low
                redZone = (int)(playerScreenPosition.Y - _iYMaxThreshold);
                if (redZone > 0) 
                {
                    if(redZone < LIMIT)
                        _v2Position.Y += redZone;
                    else
                        _v2Position.Y += LIMIT;
                }
            }

            //check if the camera can move horizontaly
            if ((_lockDirection & eLockedDirection.eLockedHorizontal) == 0)
            {
                //check if the player is too much to the left
                redZone = (int)(_iXMinThreshold - playerScreenPosition.X);
                if (redZone > 0) 
                {
                    if(redZone < LIMIT)
                        _v2Position.X -= redZone;
                    else
                        _v2Position.X -= LIMIT;
                }

                //check if the player is too much to the left
                redZone = (int)(playerScreenPosition.X - _iXMaxThreshold);
                if (redZone > 0)
                {
                    if(redZone < LIMIT)
                        _v2Position.X += redZone;
                    else
                        _v2Position.X += LIMIT;
                }
            }

            //check if the camera can move verticaly
            //if ((_lockDirection & eLockedDirection.eLockedVertical) == 0)
            //{
            //    float newY = World.Instance.PlayerPosition.Y - Visu.Instance.ScreenHeight / 2;
            //    float delta = newY - _v2Position.Y;
            //    const int LIMIT = 7;
            //    if (delta > LIMIT)
            //        _v2Position.Y += LIMIT;
            //    else if (delta < -LIMIT)
            //        _v2Position.Y -= LIMIT;
            //    else
            //        _v2Position.Y = World.Instance.PlayerPosition.Y - Visu.Instance.ScreenHeight / 2;
            //}

            ////check if the camera can move horizontaly
            //if ((_lockDirection & eLockedDirection.eLockedHorizontal) == 0)
            //    _v2Position.X = World.Instance.PlayerPosition.X - Visu.Instance.ScreenWidth / 2;
        }

      
       
    }
}
